/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import com.gprinter.utils.Command;
import com.gprinter.utils.HexUtils;
import com.gprinter.utils.LogUtils;

public class PrinterState {
    public static int resolveData(byte[] recv, Command command) {
        if (recv == null) {
            return -1;
        }
        if (recv != null) {
            LogUtils.e("printer status", "length\t" + recv.length + "\nhex:\n" + HexUtils.byte2HexStr(recv));
        }
        if (command == null) {
            return -1;
        }
        switch (command) {
            case ESC: {
                if (recv[0] == 18) {
                    return 0;
                }
                if ((recv[0] & 0x20) > 0) {
                    return -2;
                }
                if ((recv[0] & 4) > 0) {
                    return -3;
                }
                if ((recv[0] & 0x40) <= 0) break;
                return -4;
            }
            case TSC: {
                if (recv[0] == 0) {
                    return 0;
                }
                if ((recv[0] & 0x20) > 0) {
                    return 1;
                }
                if ((recv[0] & 4) > 0) {
                    return -2;
                }
                if ((recv[0] & 1) > 0) {
                    return -3;
                }
                if ((recv[0] & 0x80) > 0) {
                    return -4;
                }
                if ((recv[0] & 2) > 0) {
                    return -5;
                }
                if ((recv[0] & 3) > 0) {
                    return -6;
                }
                if ((recv[0] & 5) > 0) {
                    return -7;
                }
                if ((recv[0] & 8) > 0) {
                    return -8;
                }
                if ((recv[0] & 9) > 0) {
                    return -9;
                }
                if ((recv[0] & 0xA) > 0) {
                    return -10;
                }
                if ((recv[0] & 0xB) > 0) {
                    return -11;
                }
                if ((recv[0] & 0xC) > 0) {
                    return -12;
                }
                if ((recv[0] & 0xD) > 0) {
                    return -13;
                }
                if ((recv[0] & 0x10) <= 0) break;
                return -14;
            }
            case CPCL: {
                if (recv[0] == 0) {
                    return 0;
                }
                if ((recv[0] & 1) > 0) {
                    return 1;
                }
                if (recv[0] == 2) {
                    return -2;
                }
                if (recv[0] == 4) {
                    return -3;
                }
                if (recv[0] != 6) break;
                return -4;
            }
            case ZPL: {
                try {
                    String response = new String(recv);
                    LogUtils.e("zpl status:\n" + response);
                    String[] str = response.split("\r\n");
                    String[] str0Array = str[0].split(",");
                    String str00 = str0Array[0];
                    String str01 = str0Array[1];
                    String str02 = str0Array[2];
                    String str03 = str0Array[3];
                    String str04 = str0Array[4];
                    String str05 = str0Array[5];
                    String str06 = str0Array[6];
                    String str07 = str0Array[7];
                    String str08 = str0Array[8];
                    String str09 = str0Array[9];
                    String str010 = str0Array[10];
                    String str011 = str0Array[11];
                    String[] str1Array = str[1].split(",");
                    String str10 = str1Array[0];
                    String str11 = str1Array[1];
                    String str12 = str1Array[2];
                    String str13 = str1Array[3];
                    String str14 = str1Array[4];
                    String str15 = str1Array[5];
                    String str16 = str1Array[6];
                    String str17 = str1Array[7];
                    String str18 = str1Array[8];
                    String str19 = str1Array[9];
                    String str110 = str1Array[10];
                    String[] str2Array = str[2].split(",");
                    if (str12.contains("1")) {
                        return -3;
                    }
                    if (str01.contains("1")) {
                        return -2;
                    }
                    if (str02.contains("1")) {
                        return -14;
                    }
                    if (str011.contains("1")) {
                        return -4;
                    }
                    if (str13.contains("1")) {
                        return -8;
                    }
                    return 0;
                }
                catch (Exception e) {
                    LogUtils.e("ZPL\u72b6\u6001\u89e3\u6790\u5931\u8d25" + e.getMessage());
                    return -1;
                }
            }
        }
        return recv[0] & 0xFF;
    }
}

